#Q1 
#A. 
n <- 9
s2 <- 127
a <- 0.05
lower <- (n - 1) * s2 / qchisq(1 - a/2, n - 1)
upper <- (n - 1) * s2 / qchisq(a/2, n - 1)
lower
upper

#B. 

# Sample data
x <- c(75.3, 76.4, 83.2, 91, 80.1, 77.5, 84.8, 81.0)

# i. Sample mean
mean_x <- mean(x)
mean_x  # Output: 81.975

# ii. Estimate of population standard deviation
sd_x <- sd(x)
sd_x  # Output: 5.866129

# iii. 98% confidence interval for the population mean
n <- length(x)  # Sample size
alpha <- 0.02  # Significance level

# Calculate the standard error of the mean
se_mean <- sd_x / sqrt(n)

# Calculate the margin of error
me <- qt(1 - alpha/2, n - 1) * se_mean

# Calculate the confidence interval
ci <- c(mean_x - me, mean_x + me)
ci  # Output: 78.13519 85.81481

#C. # enter the data
business <- c(2.86, 2.77, 3.18, 2.80, 3.14, 2.87, 2.19, 3.24)
arts <- c(3, 3.44, 2.9, 3, 3.33, 3.46, 3.7, 3.8, 2.9)

# conduct the t-test
t.test(business, arts, alternative = "less", var.equal = FALSE, conf.level = 0.98)

#The p-value of the test is 0.01428, which is less than the significance level of 0.02. Therefore, we can reject the null hypothesis that the mean GPA in the business school is equal to or greater than that in the college of arts and sciences, in favor of the alternative hypothesis that the mean GPA in the business school is lower.

#Q2
#A
#A # create a data frame with the sales data
# Create a matrix of sales data
sales <- matrix(c(78, 87, 81, 89, 85,
                  94, 91, 87, 90, 88,
                  73, 78, 69, 83, 76,
                  79, 83, 78, 69, 81), 
                nrow = 4, byrow = TRUE, 
                dimnames = list(c("Free Sample", "One Gift Pack", "Cents Off", "Refund by Email"), 
                                c("Store 1", "Store 2", "Store 3", "Store 4", "Store 5")))

# Print the sales matrix
sales

# Perform chi-squared test of independence
chisq.test(sales)



#Since the p-value is greater than 0.05, we do not reject the null hypothesis that there is no association between the promotions and sales. Therefore, we cannot conclude that any one promotion is more effective than the others.

#Q2 B
test_1 <- c(3, 5, 6, 7, 8, 10)
test_2 <- c(4, 6, 7, 8, 9, 12)
# Perform Pearson's correlation test
cor.test(test_1, test_2, method = "pearson")
#Strong linear correlationship

#Q2 C

# create a data frame with the given data
data <- data.frame(X = c(16, 6, 10, 5, 12, 14),
                   Y = c(-4.4, 8, 2.1, 8.7, 0.1, -2.9))

# i. plot the scatter diagram
plot(data$X, data$Y, main = "Scatter Plot of X vs Y",
     xlab = "X", ylab = "Y")

# ii. develop the estimating equation
model <- lm(Y ~ X, data = data)
summary(model)
#Equation: 
#15.02 + (-1.247)*X

# iii. predict Y for X = 5, 6, 7
newdata <- data.frame(X = c(5, 6, 7))
pred <- predict(model, newdata = newdata)
pred

#Q3 A

# create a data frame with the given data
data <- data.frame(p = c(20, 17.5, 16, 14, 12.5, 10, 8, 6.5),
                   q = c(125, 156, 183, 190, 212, 238, 250, 276))

# i. plot the data
plot(data$p, data$q, main = "Scatter Plot of P vs Q",
     xlab = "Price (P)", ylab = "Quantity Sold (Q)")

# ii. calculate the least squares regression
model <- lm(q ~ p, data = data)
summary(model)

# iii. provide the equation that best fits the model
coef(model)
#342.15 + (-10.59) * P
# iv. predict the amount of dolls sold when price is 15
predict(model, newdata = data.frame(p = 15))


#Q3 B 

# Load the mtcars dataset
data(mtcars)
#high_mpg
mtcars$high_mpg <- ifelse(mtcars$mpg >= 20, 1, 0)
#glm 
model <- glm(high_mpg ~ wt + hp + drat + qsec, data = mtcars, family = "binomial")
#coefficients
summary(model)
#prediction
new_data <- data.frame(wt = 3.5, hp = 120, drat = 3.9, qsec = 17)
prob <- predict(model, newdata = new_data, type = "response")
prob
